# 画面設計書 47-kubeadm reset

## 概要

本ドキュメントは、kubeadmのresetコマンドの画面設計書である。kubeadm initまたはjoinで行われたノードへの変更を元に戻し、クラスタからの離脱を行うCLIコマンドの仕様を定義する。

### 本画面の処理概要

**業務上の目的・背景**：ノードのクラスタからの離脱、クラスタの再構築、トラブルシューティング時のクリーンアップなど、kubeadm initまたはjoinで行った変更をリバートする必要がある場面で使用される。resetコマンドはベストエフォートで変更を元に戻す処理を行うが、CNIプラグイン設定やネットワークルールのクリーンアップは手動で行う必要がある。

**画面へのアクセス方法**：ターミナルから `kubeadm reset [flags]` を実行する。root権限が必要。

**主要な操作・処理内容**：
1. Preflight フェーズ：リセット前の前提条件を検証
2. RemoveETCDMember フェーズ：etcdクラスタからメンバーを削除
3. CleanupNode フェーズ：ノードのクリーンアップ（証明書、kubeconfig、静的Pod等の削除）

**画面遷移**：resetはkubeadm initまたはjoinの逆操作である。reset後にはkubeadm initまたはjoinを再実行可能。

**権限による表示制御**：root権限が必要。--dry-runフラグでシミュレーション実行が可能。`-f`/`--force`フラグで確認プロンプトをスキップできる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 118 | クラスター初期化（init） | 遷移先機能 | initまたはjoinで行われた変更を元に戻す処理 |
| 121 | 証明書管理 | 補助機能 | リセット時に証明書ファイルの削除を行う |

## 画面種別

ワークフロー実行（CLIフェーズ実行型）

## URL/ルーティング

```
kubeadm reset [flags]
kubeadm reset phase <phase-name> [flags]
```

## 入出力項目

### 入力項目（フラグ）

| 項目名 | 型 | 必須 | デフォルト | 説明 |
|--------|------|------|-----------|------|
| --cert-dir | string | 任意 | /etc/kubernetes/pki | 証明書ディレクトリ |
| -f, --force | bool | 任意 | false | 確認なしでリセットを実行 |
| --dry-run | bool | 任意 | false | ドライラン実行 |
| --cleanup-tmp-dir | bool | 任意 | false | 一時ディレクトリのクリーンアップ |
| --kubeconfig | string | 任意 | /etc/kubernetes/admin.conf | kubeconfigファイルパス |
| --config | string | 任意 | "" | 設定ファイルパス |
| --ignore-preflight-errors | []string | 任意 | [] | 無視するpreflight検査 |
| --cri-socket | string | 任意 | 自動検出 | CRIソケットパス |
| --skip-phases | []string | 任意 | [] | スキップするフェーズ |

### 出力項目

リセット処理の進捗と手動クリーンアップの案内が標準出力に表示される。

## 表示項目

```
[reset] Reading configuration from the cluster...
[reset] Removing info for node "<node-name>" from ConfigMap "kubeadm-config" in the "kube-system" Namespace
[reset] Deleting files: [/etc/kubernetes/admin.conf ...]
[reset] Deleting contents of directories: [/etc/kubernetes/pki ...]
[reset] Deleting contents of stateful directories: [/var/lib/etcd ...]

The reset process does not perform cleanup of CNI plugin configuration,
network filtering rules and kubeconfig files.

For information on how to perform this cleanup manually, please see:
    https://k8s.io/docs/reference/setup-tools/kubeadm/kubeadm-reset/
```

## イベント仕様

### 1-resetコマンド実行

1. `newCmdReset` でworkflow.Runnerを作成し、3つのフェーズを登録
2. `SetDataInitializer` で設定のロードとバリデーションを実行
3. `resetRunner.Run(args)` で全フェーズを順次実行
4. 完了後、手動クリーンアップの案内メッセージを表示

### 2-データ初期化（newResetData）

1. 設定ファイルまたはデフォルトからResetConfigurationをロード
2. DryRunモードの場合、フェイクClientを作成
3. kubeconfigからクラスタ設定を取得（可能な場合）
4. CRIソケットパスの解決（Reset設定→Init設定→自動検出の優先順）
5. 証明書ディレクトリの解決（フラグ→Reset設定→クラスタ設定→デフォルト）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| RemoveETCDMember | etcdクラスタ | DELETE | etcdメンバーの削除 |
| CleanupNode | ファイルシステム | DELETE | 証明書、kubeconfig、静的Podマニフェスト等の削除 |
| CleanupNode | ConfigMap (kubeadm-config) | UPDATE | ノード情報の削除 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ | 条件 |
|-------------|------|----------|------|
| INFO-01 | 情報 | 手動クリーンアップ案内 | 正常完了時（manualCleanupInstructions） |
| WARN-01 | 警告 | `Unable to fetch the kubeadm-config ConfigMap from cluster: %v` | ConfigMap取得失敗時 |
| INFO-02 | 情報 | `Loaded client set from kubeconfig file: %s` | kubeconfig読み込み成功時 |

## 例外処理

- kubeconfigが存在しない/読めない場合でもリセットは続行される（クラスタ設定なしで動作）
- ConfigMapからの設定取得に失敗した場合も警告のみで続行
- CRIソケットの自動検出に失敗した場合はエラー

## 備考

- resetは「ベストエフォート」であり、CNIプラグイン設定やiptablesルールのクリーンアップは手動が必要
- 3つのフェーズのみで構成されており、initやjoinに比べてシンプル
- CRIソケットの解決はResetConfiguration→InitConfiguration→自動検出の3段階
- `--cleanup-tmp-dir`はKubernetesディレクトリ内のtmpディレクトリをクリーンアップする

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | reset.go | `cmd/kubeadm/app/cmd/reset.go` | resetOptions構造体（行62-68）とresetData構造体（行72-84）を理解する。resetDataはclient、criSocketPath、forceResetなどを保持 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | reset.go | `cmd/kubeadm/app/cmd/reset.go` | newCmdReset関数（行214-270）で3フェーズ（行242-244）の登録と完了メッセージ出力（行235）を確認 |

**主要処理フロー**:
1. **行218**: workflow.NewRunner()
2. **行223-237**: RunE内でRunner実行→手動クリーンアップメッセージ表示
3. **行240**: AddResetFlags
4. **行242-244**: 3フェーズの登録

#### Step 3: データ初期化を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | reset.go | `cmd/kubeadm/app/cmd/reset.go` | newResetData関数（行99-187）でDryRun判定（行119-132）、CRIソケット解決（行156-163）、証明書ディレクトリ解決（行165-172）に注目 |

### プログラム呼び出し階層図

```
newCmdReset (reset.go:214)
    |
    +-- workflow.Runner.Run()
           |
           +-- NewPreflightPhase
           +-- NewRemoveETCDMemberPhase
           +-- NewCleanupNodePhase
    |
    +-- fmt.Print(manualCleanupInstructions)
```

### データフロー図

```
[入力]                    [処理]                    [出力]

フラグ/設定ファイル ──> newResetData()
  kubeconfig               |
                    kubeconfigutil.ClientSetFromFile()
                           |
                    configutil.FetchInitConfigurationFromCluster()
                           |
                    workflow.Runner.Run()
                           |
                    各フェーズ実行 ──────> ファイル削除
                                         etcdメンバー削除
                                         stdout (進捗/案内)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| reset.go | `cmd/kubeadm/app/cmd/reset.go` | ソース | resetコマンド本体の実装 |
| phases/reset/ | `cmd/kubeadm/app/cmd/phases/reset/` | ソース | 各フェーズの実装 |
| workflow/ | `cmd/kubeadm/app/cmd/phases/workflow/` | ソース | フェーズワークフローランナー |
| runtime/ | `cmd/kubeadm/app/util/runtime/` | ソース | CRIソケット検出ユーティリティ |
| staticpod/ | `cmd/kubeadm/app/util/staticpod/` | ソース | コントロールプレーンノード判定ユーティリティ |
